<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Receipt #<?php echo e($sale->id); ?></title>
    <style>
        body {
            width: 76mm;
            margin: 2mm auto;
            font-family: monospace, 'Courier New', Courier;
            font-size: 10pt;
            background: none;
            color: #000;
        }
        .center { text-align: center; }
        .bold { font-weight: bold; }
        hr { border: none; border-top: 1px dashed #000; margin: 4px 0; }
        .item-line { display: flex; justify-content: space-between; }
        .item-indent { margin-left: 10px; font-size: 9pt; }
        @media print {
            body { margin: 0; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="center">
        <?php if($tenant->logo_path): ?>
            <img src="<?php echo e(asset('storage/' . $tenant->logo_path)); ?>" alt="Logo" style="max-height:40px; max-width:100px; display:block; margin:0 auto 2mm;">
        <?php endif; ?>
        <div class="bold"><?php echo e($tenant->name); ?></div>
        <?php if($tenant->address): ?>
            <div><?php echo e($tenant->address); ?></div>
        <?php endif; ?>
        <?php if($tenant->phone): ?>
            <div><?php echo e($tenant->phone); ?></div>
        <?php endif; ?>
        <?php if($tenant->tax_number): ?>
            <div>ICE: <?php echo e($tenant->tax_number); ?></div>
        <?php endif; ?>
    </div>
    <hr>
    <div>Sale #<?php echo e($sale->id); ?></div>
    <div>Date: <?php echo e($sale->created_at->format('Y-m-d H:i')); ?></div>
    <div>Cashier: <?php echo e($sale->user->name); ?></div>
    <div>Client: <?php echo e($sale->client->name); ?></div>
    <hr>
    <?php $__currentLoopData = $sale->saleItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="item-line">
            <span><?php echo e($item->quantity); ?> x <?php echo e($item->product->name); ?></span>
            <span><?php echo e(number_format($item->quantity * $item->price_at_sale, 2)); ?> MAD</span>
        </div>
        <div class="item-indent">@ <?php echo e(number_format($item->price_at_sale, 2)); ?> MAD</div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <hr>
    <div class="item-line">
        <span>Subtotal:</span>
        <span><?php echo e(number_format($subtotal, 2)); ?> MAD</span>
    </div>
    <?php if(isset($sale->discount_amount) && $sale->discount_amount > 0): ?>
        <div class="item-line">
            <span>Discount:</span>
            <span><?php echo e(number_format($sale->discount_amount, 2)); ?> MAD</span>
        </div>
    <?php endif; ?>
    <div class="item-line bold">
        <span>TOTAL:</span>
        <span><?php echo e(number_format($final_amount, 2)); ?> MAD</span>
    </div>
    <hr>
    <div class="item-line">
        <span>Balance After:</span>
        <span><?php echo e(number_format($sale->client->balance, 2)); ?> MAD</span>
    </div>
    <hr>
    <?php if($tenant->receipt_footer_text): ?>
        <div class="center" style="white-space: pre-line;"><?php echo e($tenant->receipt_footer_text); ?></div>
    <?php endif; ?>
    <script>
        window.onload = function() {
            window.print();
            // window.onafterprint = function() { window.close(); };
        }
    </script>
</body>
</html>
<?php /**PATH /Users/abdessamad/Documents/pos-system/resources/views/receipts/thermal_template.blade.php ENDPATH**/ ?>