<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Invoice #<?php echo e($sale->id); ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            font-size: 14px;
            line-height: 1.5;
            color: #333;
        }
        .invoice-header {
            margin-bottom: 30px;
            border-bottom: 1px solid #ddd;
            padding-bottom: 20px;
        }
        .invoice-title {
            font-size: 28px;
            font-weight: bold;
            text-align: center;
            margin: 20px 0;
            color: #4f46e5;
            text-transform: uppercase;
        }
        .company-details {
            float: left;
            width: 60%;
        }
        .invoice-details {
            float: right;
            width: 35%;
            text-align: right;
        }
        .bill-to {
            clear: both;
            margin-bottom: 30px;
            padding-top: 20px;
        }
        .bill-to-title {
            font-weight: bold;
            margin-bottom: 10px;
            border-bottom: 1px solid #ddd;
            padding-bottom: 5px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }
        table th {
            background-color: #f3f4f6;
            padding: 10px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        table td {
            padding: 10px;
            border-bottom: 1px solid #eee;
        }
        .totals {
            width: 40%;
            float: right;
        }
        .totals table {
            width: 100%;
        }
        .totals table th {
            text-align: left;
        }
        .totals table td {
            text-align: right;
        }
        .notes {
            clear: both;
            margin-top: 40px;
            border-top: 1px solid #ddd;
            padding-top: 20px;
        }
        .footer {
            margin-top: 50px;
            text-align: center;
            font-size: 12px;
            color: #777;
        }
        .clearfix:after {
            content: "";
            display: table;
            clear: both;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .font-bold {
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="invoice-header clearfix">
        <div class="company-details">
            <h2><?php echo e($tenant->name); ?></h2>
            <?php if($tenant->address): ?>
                <p><?php echo e($tenant->address); ?></p>
            <?php endif; ?>
            <?php if($tenant->phone): ?>
                <p>Phone: <?php echo e($tenant->phone); ?></p>
            <?php endif; ?>
            <?php if($tenant->email): ?>
                <p>Email: <?php echo e($tenant->email); ?></p>
            <?php endif; ?>
            <?php if($tenant->tax_number): ?>
                <p>Tax Number: <?php echo e($tenant->tax_number); ?></p>
            <?php endif; ?>
        </div>
        <div class="invoice-details">
            <div class="invoice-title">INVOICE</div>
            <p><strong>Invoice #:</strong> <?php echo e($sale->id); ?></p>
            <p><strong>Date:</strong> <?php echo e($sale->created_at->format('Y-m-d')); ?></p>
            <p><strong>Due Date:</strong> <?php echo e($sale->created_at->format('Y-m-d')); ?></p>
        </div>
    </div>

    <div class="bill-to">
        <div class="bill-to-title">BILL TO:</div>
        <p><strong><?php echo e($sale->client->name); ?></strong></p>
        <?php if($sale->client->address): ?>
            <p><?php echo e($sale->client->address); ?></p>
        <?php endif; ?>
        <?php if($sale->client->phone): ?>
            <p>Phone: <?php echo e($sale->client->phone); ?></p>
        <?php endif; ?>
        <?php if($sale->client->email): ?>
            <p>Email: <?php echo e($sale->client->email); ?></p>
        <?php endif; ?>
    </div>

    <table>
        <thead>
            <tr>
                <th width="5%">#</th>
                <th width="45%">Description</th>
                <th width="15%">Quantity</th>
                <th width="15%">Unit Price (MAD)</th>
                <th width="20%">Total (MAD)</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $sale->saleItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($index + 1); ?></td>
                    <td><?php echo e($item->product->name); ?></td>
                    <td><?php echo e($item->quantity); ?></td>
                    <td><?php echo e(number_format($item->price_at_sale, 2)); ?></td>
                    <td><?php echo e(number_format($item->line_total, 2)); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="totals">
        <table>
            <tr>
                <th>Subtotal:</th>
                <td><?php echo e(number_format($subtotal, 2)); ?> MAD</td>
            </tr>
            <?php if($sale->discount_amount > 0): ?>
            <tr>
                <th>Discount:</th>
                <td><?php echo e(number_format($sale->discount_amount, 2)); ?> MAD</td>
            </tr>
            <?php endif; ?>
            <tr>
                <th class="font-bold">Grand Total:</th>
                <td class="font-bold"><?php echo e(number_format($sale->final_amount, 2)); ?> MAD</td>
            </tr>
            <tr>
                <th>Amount Due:</th>
                <td><?php echo e(number_format($sale->final_amount, 2)); ?> MAD</td>
            </tr>
        </table>
    </div>

    <div class="notes">
        <p><strong>Payment Information:</strong></p>
        <p>Please include the invoice number when making payment.</p>
        
        <?php if($tenant->bank_name && $tenant->bank_account): ?>
        <p><strong>Bank Details:</strong><br>
           Bank Name: <?php echo e($tenant->bank_name); ?><br>
           Account Number: <?php echo e($tenant->bank_account); ?>

        </p>
        <?php endif; ?>
        
        <?php if($tenant->receipt_footer_text): ?>
        <p><?php echo e($tenant->receipt_footer_text); ?></p>
        <?php endif; ?>
    </div>

    <div class="footer">
        <p>Thank you for your business!</p>
        <p>This invoice was generated on <?php echo e(now()->format('Y-m-d H:i:s')); ?></p>
    </div>
</body>
</html>
<?php /**PATH /Users/abdessamad/Documents/pos-system/resources/views/invoices/sales_default.blade.php ENDPATH**/ ?>