<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Tenant\ActivityLogController;

// Routes that are accessible only by authenticated tenant users
Route::middleware(['auth:sanctum', 'tenant'])->group(function () {
    // Activity Logs - protected by the view-activity-log permission
    Route::get('/activity-logs', [ActivityLogController::class, 'index'])
        ->middleware('can:view-activity-log')
        ->name('tenant.activity-log.index');
});
