<?php

use App\Http\Controllers\ClientController;
use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\PurchaseController;
use App\Http\Controllers\PurchaseReturnController;
use App\Http\Controllers\SaleController;
use App\Http\Controllers\SaleReturnController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\Api\PurchaseReturnController as ApiPurchaseReturnController;
use App\Http\Controllers\Api\SaleReturnController as ApiSaleReturnController;
use App\Http\Controllers\ReportController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->group(function () {
    // User route
    Route::get('/user', function (Request $request) {
        return $request->user();
    });
    
    // Products API routes (protected by auth and tenant identification middleware)
    Route::apiResource('products', ProductController::class);
    Route::get('product-search', \App\Http\Controllers\Api\ProductSearchController::class)->name('api.products.search');
    
    // Sales API routes (protected by auth and tenant identification middleware)
    Route::get('sales/search', [\App\Http\Controllers\Api\SaleSearchController::class, 'search'])->name('api.sales.search');
    Route::apiResource('sales', SaleController::class);
    Route::post('finalize-sale', \App\Http\Controllers\Web\SaleFinalizationController::class)->name('api.sales.finalize');
    
    // Clients API routes
    Route::apiResource('clients', ClientController::class);
    
    // Client payments API routes
    Route::post('clients/{client}/payments', [PaymentController::class, 'storeClientPayment']);
    Route::get('clients/{client}/payments', [PaymentController::class, 'getClientPayments']);
    
    // Suppliers API routes
    Route::apiResource('suppliers', SupplierController::class);
    
    // Supplier payments API routes
    Route::post('suppliers/{supplier}/payments', [PaymentController::class, 'storeSupplierPayment']);
    Route::get('suppliers/{supplier}/payments', [PaymentController::class, 'getSupplierPayments']);
    
    // Purchase routes
    Route::get('purchases/search', [\App\Http\Controllers\Api\PurchaseSearchController::class, 'search'])->name('api.purchases.search');
    Route::apiResource('purchases', PurchaseController::class);
    Route::get('purchases/{purchase}/items', [PurchaseController::class, 'items']);
    
    // Purchase returns routes
    Route::post('purchases/{purchase}/returns', [ApiPurchaseReturnController::class, 'store']);
    Route::get('purchase-returns/{id}', [PurchaseReturnController::class, 'show']);
    
    // Sale returns API routes
    Route::get('sale-returns', [SaleReturnController::class, 'index']);
    Route::get('sale-returns/{id}', [SaleReturnController::class, 'show']);
    Route::post('sales/{sale}/returns', [ApiSaleReturnController::class, 'store']);
    
    // Expenses API routes
    Route::apiResource('expenses', ExpenseController::class);
    
    // Reports API routes
    Route::prefix('reports')->group(function () {
        Route::get('sales', [ReportController::class, 'salesReport']);
        Route::get('inventory', [ReportController::class, 'inventoryReport']);
        Route::get('clients/{client}', [ReportController::class, 'clientStatement']);
        Route::get('suppliers/{supplier}', [ReportController::class, 'supplierStatement']);
        Route::get('expenses', [ReportController::class, 'expenseReport']);
        Route::get('purchases', [ReportController::class, 'purchaseReport']);
        Route::get('sales-returns', [ReportController::class, 'salesReturnsReport']);
        Route::get('purchase-returns', [ReportController::class, 'purchaseReturnsReport']);
    });
});
