<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Receipt #{{ $sale->id }}</title>
    <style>
        body {
            width: 76mm;
            margin: 2mm auto;
            font-family: monospace, 'Courier New', Courier;
            font-size: 10pt;
            background: none;
            color: #000;
        }
        .center { text-align: center; }
        .bold { font-weight: bold; }
        hr { border: none; border-top: 1px dashed #000; margin: 4px 0; }
        .item-line { display: flex; justify-content: space-between; }
        .item-indent { margin-left: 10px; font-size: 9pt; }
        @media print {
            body { margin: 0; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="center">
        @if ($tenant->logo_path)
            <img src="{{ asset('storage/' . $tenant->logo_path) }}" alt="Logo" style="max-height:40px; max-width:100px; display:block; margin:0 auto 2mm;">
        @endif
        <div class="bold">{{ $tenant->name }}</div>
        @if ($tenant->address)
            <div>{{ $tenant->address }}</div>
        @endif
        @if ($tenant->phone)
            <div>{{ $tenant->phone }}</div>
        @endif
        @if ($tenant->tax_number)
            <div>ICE: {{ $tenant->tax_number }}</div>
        @endif
    </div>
    <hr>
    <div>Sale #{{ $sale->id }}</div>
    <div>Date: {{ $sale->created_at->format('Y-m-d H:i') }}</div>
    <div>Cashier: {{ $sale->user->name }}</div>
    <div>Client: {{ $sale->client->name }}</div>
    <hr>
    @foreach ($sale->saleItems as $item)
        <div class="item-line">
            <span>{{ $item->quantity }} x {{ $item->product->name }}</span>
            <span>{{ number_format($item->quantity * $item->price_at_sale, 2) }} MAD</span>
        </div>
        <div class="item-indent">@ {{ number_format($item->price_at_sale, 2) }} MAD</div>
    @endforeach
    <hr>
    <div class="item-line">
        <span>Subtotal:</span>
        <span>{{ number_format($subtotal, 2) }} MAD</span>
    </div>
    @if (isset($sale->discount_amount) && $sale->discount_amount > 0)
        <div class="item-line">
            <span>Discount:</span>
            <span>{{ number_format($sale->discount_amount, 2) }} MAD</span>
        </div>
    @endif
    <div class="item-line bold">
        <span>TOTAL:</span>
        <span>{{ number_format($final_amount, 2) }} MAD</span>
    </div>
    <hr>
    <div class="item-line">
        <span>Balance After:</span>
        <span>{{ number_format($sale->client->balance, 2) }} MAD</span>
    </div>
    <hr>
    @if ($tenant->receipt_footer_text)
        <div class="center" style="white-space: pre-line;">{{ $tenant->receipt_footer_text }}</div>
    @endif
    <script>
        window.onload = function() {
            window.print();
            // window.onafterprint = function() { window.close(); };
        }
    </script>
</body>
</html>
