<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Invoice #{{ $sale->id }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            font-size: 14px;
            line-height: 1.5;
            color: #333;
        }
        .invoice-header {
            margin-bottom: 30px;
            border-bottom: 1px solid #ddd;
            padding-bottom: 20px;
        }
        .invoice-title {
            font-size: 28px;
            font-weight: bold;
            text-align: center;
            margin: 20px 0;
            color: #4f46e5;
            text-transform: uppercase;
        }
        .company-details {
            float: left;
            width: 60%;
        }
        .invoice-details {
            float: right;
            width: 35%;
            text-align: right;
        }
        .bill-to {
            clear: both;
            margin-bottom: 30px;
            padding-top: 20px;
        }
        .bill-to-title {
            font-weight: bold;
            margin-bottom: 10px;
            border-bottom: 1px solid #ddd;
            padding-bottom: 5px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }
        table th {
            background-color: #f3f4f6;
            padding: 10px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        table td {
            padding: 10px;
            border-bottom: 1px solid #eee;
        }
        .totals {
            width: 40%;
            float: right;
        }
        .totals table {
            width: 100%;
        }
        .totals table th {
            text-align: left;
        }
        .totals table td {
            text-align: right;
        }
        .notes {
            clear: both;
            margin-top: 40px;
            border-top: 1px solid #ddd;
            padding-top: 20px;
        }
        .footer {
            margin-top: 50px;
            text-align: center;
            font-size: 12px;
            color: #777;
        }
        .clearfix:after {
            content: "";
            display: table;
            clear: both;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .font-bold {
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="invoice-header clearfix">
        <div class="company-details">
            <h2>{{ $tenant->name }}</h2>
            @if($tenant->address)
                <p>{{ $tenant->address }}</p>
            @endif
            @if($tenant->phone)
                <p>Phone: {{ $tenant->phone }}</p>
            @endif
            @if($tenant->email)
                <p>Email: {{ $tenant->email }}</p>
            @endif
            @if($tenant->tax_number)
                <p>Tax Number: {{ $tenant->tax_number }}</p>
            @endif
        </div>
        <div class="invoice-details">
            <div class="invoice-title">INVOICE</div>
            <p><strong>Invoice #:</strong> {{ $sale->id }}</p>
            <p><strong>Date:</strong> {{ $sale->created_at->format('Y-m-d') }}</p>
            <p><strong>Due Date:</strong> {{ $sale->created_at->format('Y-m-d') }}</p>
        </div>
    </div>

    <div class="bill-to">
        <div class="bill-to-title">BILL TO:</div>
        <p><strong>{{ $sale->client->name }}</strong></p>
        @if($sale->client->address)
            <p>{{ $sale->client->address }}</p>
        @endif
        @if($sale->client->phone)
            <p>Phone: {{ $sale->client->phone }}</p>
        @endif
        @if($sale->client->email)
            <p>Email: {{ $sale->client->email }}</p>
        @endif
    </div>

    <table>
        <thead>
            <tr>
                <th width="5%">#</th>
                <th width="45%">Description</th>
                <th width="15%">Quantity</th>
                <th width="15%">Unit Price (MAD)</th>
                <th width="20%">Total (MAD)</th>
            </tr>
        </thead>
        <tbody>
            @foreach($sale->saleItems as $index => $item)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $item->product->name }}</td>
                    <td>{{ $item->quantity }}</td>
                    <td>{{ number_format($item->price_at_sale, 2) }}</td>
                    <td>{{ number_format($item->line_total, 2) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="totals">
        <table>
            <tr>
                <th>Subtotal:</th>
                <td>{{ number_format($subtotal, 2) }} MAD</td>
            </tr>
            @if($sale->discount_amount > 0)
            <tr>
                <th>Discount:</th>
                <td>{{ number_format($sale->discount_amount, 2) }} MAD</td>
            </tr>
            @endif
            <tr>
                <th class="font-bold">Grand Total:</th>
                <td class="font-bold">{{ number_format($sale->final_amount, 2) }} MAD</td>
            </tr>
            <tr>
                <th>Amount Due:</th>
                <td>{{ number_format($sale->final_amount, 2) }} MAD</td>
            </tr>
        </table>
    </div>

    <div class="notes">
        <p><strong>Payment Information:</strong></p>
        <p>Please include the invoice number when making payment.</p>
        
        @if($tenant->bank_name && $tenant->bank_account)
        <p><strong>Bank Details:</strong><br>
           Bank Name: {{ $tenant->bank_name }}<br>
           Account Number: {{ $tenant->bank_account }}
        </p>
        @endif
        
        @if($tenant->receipt_footer_text)
        <p>{{ $tenant->receipt_footer_text }}</p>
        @endif
    </div>

    <div class="footer">
        <p>Thank you for your business!</p>
        <p>This invoice was generated on {{ now()->format('Y-m-d H:i:s') }}</p>
    </div>
</body>
</html>
