<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StorePurchaseRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return $this->user()->can('manage-purchases');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'supplier_id' => 'required|exists:suppliers,id,tenant_id,' . $this->user()->tenant_id,
            'notes' => 'nullable|string',
            'status' => 'nullable|string|in:completed,pending,cancelled',
            'items' => 'required|array|min:1',
            'items.*.product_id' => 'required|exists:products,id,tenant_id,' . $this->user()->tenant_id,
            'items.*.quantity' => 'required|integer|min:1',
            'items.*.cost_price' => 'required|numeric|min:0',
        ];
    }
}
