<?php

namespace App\Http\Controllers\Tenant;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Inertia\Inertia;
use App\Models\Tenant;
use App\Http\Requests\UpdateTenantSettingsRequest;

class SettingsController extends Controller
{
    public function edit(Request $request)
    {
        $user = $request->user();
        if ($user->is_superadmin || !$user->tenant) {
            abort(403, 'Unauthorized');
        }
        $tenant = $user->tenant;
        return Inertia::render('Tenant/Settings/Edit', [
            'tenant' => $tenant
        ]);
    }

    public function update(UpdateTenantSettingsRequest $request)
    {
        $user = $request->user();
        if ($user->is_superadmin || !$user->tenant) {
            abort(403, 'Unauthorized');
        }
        $tenant = $user->tenant;
        $validated = $request->validated();
        
        // Update text fields only
        $tenant->update(collect($validated)->except('logo')->toArray());

        // Handle logo upload
        if ($request->hasFile('logo') && $request->file('logo')->isValid()) {
            $storagePath = "tenants/{$tenant->id}/logos";
            // Delete old logo if exists
            if ($tenant->logo_path) {
                Storage::disk('public')->delete($tenant->logo_path);
            }
            $path = $request->file('logo')->store($storagePath, 'public');
            $tenant->logo_path = $path;
            $tenant->save();
        }

        return redirect()->route('tenant.settings.edit')->with('success', __('Settings updated successfully.'));
    }
}
