<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Multitenancy\Models\Concerns\UsesTenantConnection;

class SaleReturn extends Model
{
    use HasFactory, UsesTenantConnection;
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'tenant_id',
        'sale_id',
        'client_id',
        'user_id',
        'reason',
        'returned_amount',
        'status',
    ];
    
    /**
     * Get the sale associated with the return.
     */
    public function sale()
    {
        return $this->belongsTo(Sale::class);
    }
    
    /**
     * Get the client associated with the return.
     */
    public function client()
    {
        return $this->belongsTo(Client::class);
    }
    
    /**
     * Get the user who created the return.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    
    /**
     * Get the items for the return.
     */
    public function items()
    {
        return $this->hasMany(SaleReturnItem::class);
    }
    
    /**
     * Get the tenant that owns the sale return.
     */
    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }
}
