<?php

namespace App\Http\Controllers\Tenant;

use App\Http\Controllers\Controller;
use App\Models\Sale;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ReceiptController extends Controller
{
    public function html(Sale $sale)
    {
        // Authorization: ensure the sale belongs to the current tenant
        $user = Auth::user();
        if ($sale->tenant_id !== $user->tenant_id) {
            abort(403, 'Unauthorized');
        }

        $sale->load(['tenant', 'user', 'client', 'saleItems.product']);
        $tenant = $sale->tenant;

        // Calculate subtotal (for backward compatibility with existing sales)
        $subtotal = $sale->saleItems->sum(function ($item) {
            return $item->quantity * $item->price_at_sale;
        });
        
        // Use the stored final_amount if available, otherwise calculate it
        $final_amount = $sale->final_amount ?? ($subtotal - ($sale->discount_amount ?? 0));

        return view('receipts.thermal_template', compact('sale', 'tenant', 'subtotal', 'final_amount'));
    }
}
