<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Multitenancy\Models\Concerns\UsesTenantConnection;

class PurchaseReturnItem extends Model
{
    use HasFactory, UsesTenantConnection;
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'tenant_id',
        'purchase_return_id',
        'product_id',
        'purchase_item_id',
        'quantity',
        'cost_price',
        'subtotal',
    ];
    
    /**
     * Get the purchase return that owns the item.
     */
    public function purchaseReturn()
    {
        return $this->belongsTo(PurchaseReturn::class);
    }
    
    /**
     * Get the product associated with the item.
     */
    public function product()
    {
        return $this->belongsTo(Product::class);
    }
    
    /**
     * Get the original purchase item associated with this return item.
     */
    public function purchaseItem()
    {
        return $this->belongsTo(PurchaseItem::class);
    }
    
    /**
     * Get the tenant that owns the purchase return item.
     */
    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }
}
