<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Multitenancy\Models\Concerns\UsesTenantConnection;

class PurchaseReturn extends Model
{
    use HasFactory, UsesTenantConnection;
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'tenant_id',
        'purchase_id',
        'supplier_id',
        'user_id',
        'reason',
        'returned_amount',
        'status',
    ];
    
    /**
     * Get the purchase associated with the return.
     */
    public function purchase()
    {
        return $this->belongsTo(Purchase::class);
    }
    
    /**
     * Get the supplier associated with the return.
     */
    public function supplier()
    {
        return $this->belongsTo(Supplier::class);
    }
    
    /**
     * Get the user who created the return.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    
    /**
     * Get the items for the return.
     */
    public function items()
    {
        return $this->hasMany(PurchaseReturnItem::class);
    }
    
    /**
     * Get the tenant that owns the purchase return.
     */
    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }
}
