<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ProductSearchController extends Controller
{
    /**
     * Search for products by name or SKU
     * 
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function __invoke(Request $request)
    {
        $search = $request->input('search');
        
        // Get products matching the search query for the current tenant
        $products = Product::where('tenant_id', Auth::user()->tenant_id)
            ->where(function($query) use ($search) {
                $query->where('name', 'like', "%{$search}%")
                      ->orWhere('sku', 'like', "%{$search}%");
            })
            ->select('id', 'name', 'sku', 'price as selling_price', 'quantity as stock_quantity')
            ->limit(10)
            ->get();
            
        return response()->json(['data' => $products]);
    }
}
