<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Multitenancy\Models\Concerns\UsesTenantConnection;

class Client extends Model
{
    use HasFactory, UsesTenantConnection;
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'tenant_id',
        'name',
        'email',
        'phone',
        'address',
        'notes',
        'balance',
        'is_default',
    ];
    
    /**
     * Get the tenant that owns the client.
     */
    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }
    
    /**
     * Get the sales for the client.
     */
    public function sales()
    {
        return $this->hasMany(Sale::class);
    }
    
    /**
     * Get the payments for the client.
     */
    public function payments()
    {
        return $this->morphMany(Payment::class, 'paymentable');
    }
    
    /**
     * Get the sale returns for the client.
     */
    public function saleReturns()
    {
        return $this->hasMany(SaleReturn::class);
    }
}
