<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use App\Models\Sale;
use App\Models\Client;

class UpdateSalesWithDiscountAndFinalAmount extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sales:update-discount-fields';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update existing sales with discount_amount=0 and final_amount=total_amount, then recalculate client balances';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Starting update of sales records...');
        
        // Step 1: Update all existing sales to have discount_amount = 0 and final_amount = total_amount
        $salesUpdated = DB::statement('UPDATE sales SET discount_amount = 0, final_amount = total_amount WHERE discount_amount IS NULL OR final_amount IS NULL OR final_amount = 0');
        
        if ($salesUpdated) {
            $this->info('Sales records updated successfully.');
        } else {
            $this->error('Failed to update sales records.');
            return 1;
        }
        
        // Step 2: Recalculate client balances
        $this->info('Recalculating client balances...');
        
        $clients = Client::all();
        $updatedCount = 0;
        
        foreach ($clients as $client) {
            $this->line('Processing client #' . $client->id);
            
            // Get all sales for this client
            $sales = Sale::where('client_id', $client->id)->get();
            
            // Calculate the correct balance based on final_amount
            $balance = 0;
            
            foreach ($sales as $sale) {
                $balance += $sale->final_amount;
            }
            
            // Get all payments for this client
            $payments = $client->payments;
            
            foreach ($payments as $payment) {
                $balance -= $payment->amount;
            }
            
            // Get all sale returns for this client
            $saleReturns = DB::table('sale_returns')->where('client_id', $client->id)->get();
            
            foreach ($saleReturns as $return) {
                $balance -= $return->returned_amount;
            }
            
            // Update the client's balance
            $client->balance = $balance;
            $client->save();
            $updatedCount++;
        }
        
        $this->info('Updated balances for ' . $updatedCount . ' clients.');
        $this->info('Update completed successfully!');
        
        return 0;
    }
}
