<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreSaleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return $this->user()->can('process-sales');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'client_id' => [
                'required',
                'integer',
                'exists:clients,id,tenant_id,' . $this->user()->tenant_id,
            ],
            'items' => 'required|array|min:1',
            'items.*.product_id' => [
                'required',
                'integer',
                'exists:products,id,tenant_id,' . $this->user()->tenant_id,
            ],
            'items.*.quantity' => 'required|integer|min:1',
            'items.*.selling_price' => 'nullable|numeric|min:0',
            'status' => 'nullable|string|in:completed,pending,cancelled',
        ];
    }
}
