<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreClientPaymentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return $this->user()->can('record-payments');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $rules = [
            'amount' => 'required|numeric|gt:0',
            'method' => 'required|string|in:cash,bank_transfer,check',
            'payment_date' => 'required|date',
            'notes' => 'nullable|string',
        ];
        
        // Add method-specific validation rules
        if ($this->method === 'bank_transfer') {
            $rules['bank_transfer_reference'] = 'required|string';
            $rules['bank_transfer_receipt_path'] = 'nullable|string';
        } else if ($this->method === 'check') {
            $rules['check_number'] = 'required|string';
            $rules['check_due_date'] = 'required|date|after_or_equal:payment_date';
        }
        
        return $rules;
    }
}
