<?php

namespace App\Http\Middleware;

use App\Models\Tenant;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class IdentifyTenant
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Skip tenant identification for superadmins
        if (Auth::check() && !Auth::user()->is_superadmin && Auth::user()->tenant_id) {
            $tenant = Tenant::find(Auth::user()->tenant_id);
            
            if ($tenant) {
                $tenant->makeCurrent();
            }
        }
        
        return $next($request);
    }
}
