<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureTenantAdmin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = $request->user();
        
        // Ensure the user is authenticated, is a tenant admin, and not a superadmin
        if (!$user || $user->is_superadmin || $user->role !== 'admin') {
            abort(403, 'Unauthorized action. Only tenant administrators can access this resource.');
        }
        
        return $next($request);
    }
}
