<?php

namespace Database\Seeders;

use App\Models\Tenant;
use App\Models\Category;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class TenantSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create sample tenants for the POS system
        $tenants = [
            [
                'name' => 'Default Business',
                'domain' => 'default.pos-system.test',
            ],
            [
                'name' => 'Second Branch',
                'domain' => 'second.pos-system.test',
            ]
        ];
        
        foreach ($tenants as $tenantData) {
            $tenant = Tenant::create($tenantData);
            
            // Create default Uncategorized category for each tenant
            Category::create([
                'tenant_id' => $tenant->id,
                'name' => 'Uncategorized',
                'slug' => 'uncategorized',
                'description' => 'Default category for uncategorized products',
                'is_default' => true,
                'active' => true,
            ]);
        }
    }
}
