<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use Spatie\Permission\PermissionRegistrar;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Reset cached roles and permissions
        app()[PermissionRegistrar::class]->forgetCachedPermissions();

        // Define Permissions
        $permissions = [
            // Dashboard
            'view-dashboard',
            
            // Products
            'view-products', 'manage-products',
            'create-products',
            'edit-products',
            'delete-products',
            
            // Sales
            'view-sales', 'manage-sales',
            'create-sales',
            'edit-sales',
            'delete-sales',
            'process-sales',
            
            // Clients
            'view-clients', 'manage-clients',
            'create-clients',
            'edit-clients',
            'delete-clients',
            
            // Suppliers
            'view-suppliers', 'manage-suppliers',
            'create-suppliers',
            'edit-suppliers',
            'delete-suppliers',
            
            // Payments
            'view-payments', 'manage-payments',
            'record-payments',
            
            // Purchases
            'view-purchases', 'manage-purchases',
            'create-purchases',
            'edit-purchases',
            'delete-purchases',
            
            // Expenses
            'view-expenses', 'manage-expenses',
            'create-expenses',
            'edit-expenses',
            'delete-expenses',
            
            // Returns
            'view-sales-returns',
            'process-sales-returns',
            'view-purchase-returns',
            'process-purchase-returns',
            
            // Reports
            'view-reports', 'manage-reports',
            
            // Users (for tenant admins)
            'view-users', 'manage-users',
            'create-users',
            'edit-users',
            'delete-users',
            
            // Tenant Settings
            'view-tenant-settings',
            'edit-tenant-settings', 'manage-tenant-settings',
            
            // Superadmin specific
            'access-superadmin-panel',
            'manage-tenants'
        ];

        // Create permissions if they don't exist
        foreach ($permissions as $permission) {
            Permission::findOrCreate($permission, 'web');
        }

        // Create a global superadmin role (not tenant-specific) if it doesn't exist
        $superadminRole = Role::firstOrCreate(['name' => 'superadmin', 'guard_name' => 'web']);
        $superadminRole->syncPermissions(Permission::all());
    }
}
