<?php

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Create superadmin user (not associated with any tenant)
        \App\Models\User::create([
            'name' => 'Super Admin',
            'email' => 'superadmin@example.com',
            'password' => \Illuminate\Support\Facades\Hash::make('password'), // Change in production!
            'is_superadmin' => true,
            'tenant_id' => null,
            'role' => 'admin' // Set to admin even though it's irrelevant for superadmin
        ]);
        
        // Call the PermissionSeeder first to create permissions
        // Then TenantSeeder to create tenants, followed by UserSeeder
        $this->call([
            PermissionSeeder::class,
            TenantSeeder::class,
            UserSeeder::class,
            ClientSeeder::class,
        ]);
    }
}
