<?php

namespace Database\Seeders;

use App\Models\Client;
use App\Models\Tenant;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ClientSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get all tenants
        $tenants = Tenant::all();
        
        foreach ($tenants as $tenant) {
            // Create a default cash client for each tenant
            Client::create([
                'tenant_id' => $tenant->id,
                'name' => 'Cash Client',
                'email' => null,
                'phone' => null,
                'address' => null,
                'notes' => 'Default client for cash sales',
                'balance' => 0,
                'is_default' => true,
            ]);
        }
    }
}
