<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Category;
use App\Models\Tenant;
use Illuminate\Support\Str;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get all tenants
        $tenants = Tenant::all();
        
        // Create default categories for each tenant
        $categories = [
            [
                'name' => 'Electronics',
                'description' => 'Electronic devices and accessories',
                'is_default' => false,
            ],
            [
                'name' => 'Clothing',
                'description' => 'Clothing and apparel',
                'is_default' => false,
            ],
            [
                'name' => 'Food & Beverages',
                'description' => 'Food items and beverages',
                'is_default' => false,
            ],
            [
                'name' => 'Home & Kitchen',
                'description' => 'Home goods and kitchen appliances',
                'is_default' => false,
            ],
            [
                'name' => 'Beauty & Personal Care',
                'description' => 'Beauty products and personal care items',
                'is_default' => false,
            ],
            [
                'name' => 'Stationery',
                'description' => 'Office supplies and stationery items',
                'is_default' => false,
            ],
        ];
        
        foreach ($tenants as $tenant) {
            // Make sure Uncategorized category exists for each tenant
            $uncategorizedExists = Category::where('tenant_id', $tenant->id)
                ->where('is_default', true)
                ->exists();
                
            if (!$uncategorizedExists) {
                Category::create([
                    'tenant_id' => $tenant->id,
                    'name' => 'Uncategorized',
                    'slug' => 'uncategorized',
                    'description' => 'Default category for uncategorized products',
                    'is_default' => true,
                    'active' => true,
                ]);
            }
            
            // Create other categories for each tenant
            foreach ($categories as $category) {
                Category::create([
                    'tenant_id' => $tenant->id,
                    'name' => $category['name'],
                    'slug' => Str::slug($category['name']),
                    'description' => $category['description'],
                    'is_default' => $category['is_default'],
                    'active' => true,
                ]);
            }
        }
    }
}
