<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use App\Models\User;
use Illuminate\Support\Facades\DB;

class AssignMissingPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get the cashier user
        $cashier = User::find(5);
        
        if (!$cashier) {
            $this->command->error('Cashier user with ID 5 not found!');
            return;
        }
        
        // Permissions to assign
        $permissionsToAssign = [
            'view expenses',
            'create expenses',
            'edit expenses',
            'delete expenses',
            'manage expenses',
            'view reports',
            'view purchases',
            'create purchases',
            'edit purchases',
            'delete purchases',
            'manage purchases'
        ];
        
        // Assign each permission
        foreach ($permissionsToAssign as $permissionName) {
            // Check if permission exists
            $permission = Permission::where('name', $permissionName)->first();
            
            if (!$permission) {
                // Create the permission if it doesn't exist
                $permission = Permission::create(['name' => $permissionName]);
                $this->command->info("Created permission: {$permissionName}");
            }
            
            // Assign permission to user if they don't already have it
            if (!$cashier->hasPermissionTo($permissionName)) {
                $cashier->givePermissionTo($permission);
                $this->command->info("Assigned {$permissionName} to cashier user");
            } else {
                $this->command->info("Cashier already has permission: {$permissionName}");
            }
        }
        
        $this->command->info('All permissions assigned successfully!');
    }
}
