<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\PermissionRegistrar;

class AddMissingPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Reset cached roles and permissions
        app()[PermissionRegistrar::class]->forgetCachedPermissions();

        // Define missing permissions
        $missingPermissions = [
            // Ensure both formats exist for all permissions
            // Space format
            'manage sales',
            'manage products',
            'manage purchases',
            'manage expenses',
            'manage clients',
            'manage suppliers',
            'manage users',
            'process purchase returns',
            'process sales returns',
            'record payments',
            'access superadmin panel',
            'view products',
            'create products',
            'edit products',
            'delete products',
            'view sales',
            'create sales',
            'edit sales',
            'delete sales',
            'process sales',
            
            // Hyphen format
            'manage-sales',
            'manage-products',
            'manage-purchases',
            'manage-expenses',
            'manage-clients',
            'manage-suppliers',
            'manage-users',
            'process-purchase-returns',
            'process-sales-returns',
            'record-payments',
            'access-superadmin-panel',
            'view-products',
            'create-products',
            'edit-products',
            'delete-products',
            'view-sales',
            'create-sales',
            'edit-sales',
            'delete-sales',
            'process-sales',
        ];

        // Create permissions if they don't exist
        foreach ($missingPermissions as $permission) {
            if (!Permission::where('name', $permission)->exists()) {
                Permission::create(['name' => $permission]);
                $this->command->info("Created permission: {$permission}");
            } else {
                $this->command->info("Permission already exists: {$permission}");
            }
        }
    }
}
