<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            $table->decimal('total_cost', 10, 2)->nullable()->after('final_amount');
            $table->decimal('gross_profit', 10, 2)->nullable()->after('total_cost');
            $table->decimal('profit_margin_percentage', 5, 2)->nullable()->after('gross_profit');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            $table->dropColumn('total_cost');
            $table->dropColumn('gross_profit');
            $table->dropColumn('profit_margin_percentage');
        });
    }
};
