<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sale_items', function (Blueprint $table) {
            $table->decimal('cost_at_sale', 10, 2)->nullable()->after('price_at_sale');
            $table->decimal('unit_profit', 10, 2)->nullable()->after('cost_at_sale');
            $table->decimal('total_cost', 10, 2)->nullable()->after('unit_profit');
            $table->decimal('total_profit', 10, 2)->nullable()->after('total_cost');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sale_items', function (Blueprint $table) {
            $table->dropColumn('cost_at_sale');
            $table->dropColumn('unit_profit');
            $table->dropColumn('total_cost');
            $table->dropColumn('total_profit');
        });
    }
};
