<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('tenants', function (Blueprint $table) {
            $table->text('address')->nullable();
            $table->string('phone')->nullable();
            $table->string('email')->nullable(); // business contact email
            $table->string('tax_number')->nullable(); // ICE in Morocco
            $table->string('logo_path')->nullable();
            $table->text('receipt_footer_text')->nullable();
        });
    }

    public function down()
    {
        Schema::table('tenants', function (Blueprint $table) {
            $table->dropColumn(['address', 'phone', 'email', 'tax_number', 'logo_path', 'receipt_footer_text']);
        });
    }
};
