<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Doctrine\DBAL\Types\Type;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Add is_superadmin boolean column with default false and index
            $table->boolean('is_superadmin')->default(false)->index();
            
            // Make tenant_id nullable (superadmins will have tenant_id = NULL)
            $table->foreignId('tenant_id')->nullable()->change();
            
            // Update role column to only accept 'admin' and 'cashier' for tenant users
            // First check if the column is an ENUM type
            $connection = Schema::getConnection();
            $dbSchemaManager = $connection->getDoctrineSchemaManager();
            $columns = $dbSchemaManager->listTableColumns('users');
            
            // If role is an ENUM type, modify it
            if (isset($columns['role']) && strpos($columns['role']->getType()->getName(), 'enum') !== false) {
                // Drop the existing enum and recreate it with only 'admin' and 'cashier'
                $table->dropColumn('role');
                $table->enum('role', ['admin', 'cashier'])->nullable();
            }
            // If it's a string, we'll handle the validation in the application logic
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Revert changes
            $table->dropColumn('is_superadmin');
            $table->foreignId('tenant_id')->nullable(false)->change();
            
            // Note: We won't revert the role column changes as it would be complex
            // and potentially destructive to restore the original enum values
        });
    }
};
