<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            // Drop the existing total_amount column and recreate it with proper defaults
            $table->dropColumn('total_amount');
        });
        
        Schema::table('sales', function (Blueprint $table) {
            // Add the column back with proper definition
            $table->decimal('total_amount', 10, 2)->default(0)->after('client_id');
        });
        
        // Update existing sales to have correct total amounts
        DB::statement("
            UPDATE sales s
            SET s.total_amount = (
                SELECT COALESCE(SUM(si.price_at_sale * si.quantity), 0)
                FROM sale_items si
                WHERE si.sale_id = s.id
            )
        ");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            // If we need to roll back, we'll recreate the column with its original definition
            $table->dropColumn('total_amount');
            $table->decimal('total_amount', 10, 2)->nullable()->after('client_id');
        });
    }
};
