<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sale_return_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->onDelete('cascade');
            $table->foreignId('sale_return_id')->constrained()->onDelete('cascade');
            $table->foreignId('product_id')->constrained()->onDelete('restrict');
            $table->foreignId('sale_item_id')->constrained()->onDelete('restrict'); // Reference to the original sale item
            $table->integer('quantity'); // Quantity being returned
            $table->decimal('price_at_sale', 15, 2); // Original price from sale_item
            $table->decimal('subtotal', 15, 2); // quantity * price_at_sale
            $table->timestamps();
            
            // Indexes
            $table->index('tenant_id');
            $table->index('sale_return_id');
            $table->index('product_id');
            $table->index('sale_item_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sale_return_items');
    }
};
