<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sale_returns', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->onDelete('cascade');
            $table->foreignId('sale_id')->constrained()->onDelete('restrict');
            $table->foreignId('client_id')->constrained()->onDelete('restrict'); // Denormalized for easier querying/scoping
            $table->foreignId('user_id')->constrained()->onDelete('restrict');
            $table->text('reason')->nullable();
            $table->decimal('returned_amount', 15, 2);
            $table->string('status')->default('completed'); // completed, pending, cancelled
            $table->timestamps();
            
            // Indexes
            $table->index('tenant_id');
            $table->index('sale_id');
            $table->index('client_id');
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sale_returns');
    }
};
