<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchase_return_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->onDelete('cascade');
            $table->foreignId('purchase_return_id')->constrained()->onDelete('cascade');
            $table->foreignId('product_id')->constrained()->onDelete('restrict');
            $table->foreignId('purchase_item_id')->constrained()->onDelete('restrict'); // Reference to the original purchase item
            $table->integer('quantity'); // Quantity being returned
            $table->decimal('cost_price', 15, 2); // Original cost price from purchase_item
            $table->decimal('subtotal', 15, 2); // quantity * cost_price
            $table->timestamps();
            
            // Indexes
            $table->index('tenant_id');
            $table->index('purchase_return_id');
            $table->index('product_id');
            $table->index('purchase_item_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchase_return_items');
    }
};
