<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->onDelete('cascade');
            $table->morphs('paymentable'); // Creates paymentable_id and paymentable_type columns
            $table->foreignId('user_id')->constrained()->onDelete('restrict');
            $table->decimal('amount', 15, 2);
            $table->string('method'); // cash, bank_transfer, check
            $table->date('payment_date');
            $table->string('bank_transfer_reference')->nullable();
            $table->string('bank_transfer_receipt_path')->nullable();
            $table->string('check_number')->nullable();
            $table->date('check_due_date')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();
            
            $table->index('tenant_id');
            $table->index('user_id');
            $table->index('method');
            $table->index('check_due_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
