<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->string('barcode')->nullable()->after('sku');
            $table->decimal('purchase_price', 10, 2)->default(0)->after('price');
            $table->integer('reorder_point')->nullable()->default(0)->after('quantity');
            
            // Create a unique index for barcode within each tenant
            $table->unique(['tenant_id', 'barcode'], 'products_tenant_id_barcode_unique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropUnique('products_tenant_id_barcode_unique');
            $table->dropColumn(['barcode', 'purchase_price', 'reorder_point']);
        });
    }
};
