<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('payments', function (Blueprint $table) {
            $table->enum('check_status', ['pending', 'paid', 'unpaid'])
                  ->default('pending')
                  ->after('check_due_date')
                  ->comment('Status of check payments: pending (default), paid (cleared), unpaid (bounced/failed)');
            
            $table->index('check_status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payments', function (Blueprint $table) {
            $table->dropIndex(['check_status']);
            $table->dropColumn('check_status');
        });
    }
};