<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Multitenancy\Models\Tenant as BaseTenant;

class Tenant extends BaseTenant
{
    use HasFactory;
    
    protected $fillable = [
        'name',
        'domain',
        'database',
        'address',
        'phone',
        'email', // business contact email
        'tax_number',
        'logo_path',
        'receipt_footer_text',
    ];
    
    /**
     * Get the users for the tenant.
     */
    public function users()
    {
        return $this->hasMany(User::class);
    }
}
