<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Multitenancy\Models\Concerns\UsesTenantConnection;

class Purchase extends BaseModel
{
    use HasFactory, UsesTenantConnection, SoftDeletes;
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'tenant_id',
        'supplier_id',
        'user_id',
        'total_amount',
        'status',
        'notes',
    ];
    
    /**
     * Get the supplier associated with the purchase.
     */
    public function supplier()
    {
        return $this->belongsTo(Supplier::class);
    }
    
    /**
     * Get the user who created the purchase.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    
    /**
     * Get the items for the purchase.
     */
    public function items()
    {
        return $this->hasMany(PurchaseItem::class);
    }
    
    /**
     * Get the returns for the purchase.
     */
    public function returns()
    {
        return $this->hasMany(PurchaseReturn::class);
    }
    
    /**
     * Get the tenant that owns the purchase.
     */
    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }
}
