<?php

namespace App\Traits;

use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\Contracts\Activity;
use App\Models\Tenant;

trait TenantActivityLogging
{
    use LogsActivity;
    
    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logOnly($this->getLogAttributes())
            ->logOnlyDirty()
            ->dontSubmitEmptyLogs()
            ->setDescriptionForEvent(function(string $eventName) {
                return class_basename($this) . " was {$eventName}";
            });
    }
    
    protected function getLogAttributes(): array
    {
        return $this->logAttributes ?? ['*'];
    }
    
    public function tapActivity(Activity $activity, string $eventName)
    {
        // Add tenant_id to properties for context
        $tenantId = null;
        
        // Get tenant_id from authenticated user
        if (auth()->check() && auth()->user()->tenant_id) {
            $tenantId = auth()->user()->tenant_id;
        }
        // Or from current tenant context
        else if (Tenant::current()) {
            $tenantId = Tenant::current()->id;
        }
        // For Tenant model, use its own ID
        else if ($this instanceof \App\Models\Tenant) {
            $tenantId = $this->id;
        }
        
        // Store tenant_id in the properties for context
        if ($tenantId) {
            $properties = $activity->properties ?? collect([]);
            $activity->properties = $properties->merge([
                'tenant_id' => $tenantId,
                'user_name' => optional(auth()->user())->name,
                'ip_address' => request()->ip()
            ]);
            
            // Set the direct tenant_id column as well
            $activity->tenant_id = $tenantId;
        }
    }
}
