<?php

namespace App\Providers;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // We're now using selective strict attribute checking via BaseModel
        // This allows us to have strict checking for business models while avoiding Jetstream issues
        \Inertia\Inertia::share([
            'auth' => function () {
                $user = \Illuminate\Support\Facades\Auth::user();
                return $user ? [
                    'user' => [
                        'id' => $user->id,
                        'name' => $user->name,
                        'email' => $user->email,
                        'role' => $user->role,
                    ]
                ] : null;
            },
            'can' => function () {
                $user = \Illuminate\Support\Facades\Auth::user();
                if (!$user) return [];
                
                // Get all permissions the user has
                $allPermissions = $user->getAllPermissions()->pluck('name')->toArray();
                
                // Create an associative array for quick lookup
                $permissionMap = [];
                foreach ($allPermissions as $permission) {
                    $permissionMap[$permission] = true;
                }
                
                // Add specific permissions we need in the frontend
                return [
                    'manage-products' => $user->hasPermissionTo('manage-products'),
                    'manage-sales' => $user->hasPermissionTo('manage-sales'),
                    'manage-purchases' => $user->hasPermissionTo('manage-purchases'),
                    'process_sales_returns' => $user->hasPermissionTo('process-sales-returns'),
                    'process_purchase_returns' => $user->hasPermissionTo('process-purchase-returns'),
                    // Add other permissions as needed
                ];
            },
            'flash' => function () {
                return [
                    'success' => session('success'),
                    'error' => session('error'),
                ];
            },
        ]);
    }
}
