<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Spatie\Activitylog\Models\Activity;
use App\Models\Tenant;

class ActivityLogServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Auto-set tenant_id on all activity logs
        Activity::saving(function (Activity $activity) {
            // Skip if tenant_id is already set
            if ($activity->tenant_id) {
                return;
            }
            
            // Set from authenticated user's tenant
            if (auth()->check() && auth()->user()->tenant_id) {
                $activity->tenant_id = auth()->user()->tenant_id;
                return;
            }
            
            // Fall back to current tenant context if available
            if (Tenant::current()) {
                $activity->tenant_id = Tenant::current()->id;
                return;
            }
            
            // For tenant model itself, check if it's in the properties
            $properties = $activity->properties;
            if ($properties && $properties->has('tenant_id_context')) {
                $activity->tenant_id = $properties->get('tenant_id_context');
            }
        });
    }
}
