<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Multitenancy\Models\Tenant as BaseTenant;

class Tenant extends BaseTenant
{
    use HasFactory;
    
    protected $fillable = [
        'name',
        'domain',
        'database',
        'address',
        'phone',
        'email', // business contact email
        'tax_number',
        'logo_path',
        'receipt_footer_text',
    ];
    
    /**
     * Get the users for the tenant.
     */
    public function users()
    {
        return $this->hasMany(User::class);
    }
    
    /**
     * Get the categories for the tenant.
     */
    public function categories()
    {
        return $this->hasMany(Category::class);
    }
    
    /**
     * Get the settings for the tenant.
     *
     * @return array
     */
    public function getSettingsAttribute()
    {
        // Default settings for all tenants
        return [
            'tenant_name' => $this->name,
            'tenant_address' => $this->address,
            'tenant_phone' => $this->phone,
            'tenant_email' => $this->email,
            'tax_id' => $this->tax_number,
            'receipt_footer' => $this->receipt_footer_text,
            'currency' => 'MAD',
            'default_tva_rate' => 20, // 20% default VAT rate for Morocco
            'allow_negative_inventory' => false,
            'default_language' => 'fr',
            'pos_default_client_id' => null
        ];
    }
}
