<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Multitenancy\Models\Concerns\UsesTenantConnection;

class Supplier extends Model
{
    use HasFactory, UsesTenantConnection;
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'tenant_id',
        'name',
        'email',
        'phone',
        'address',
        'notes',
        'balance',
    ];
    
    /**
     * Get the tenant that owns the supplier.
     */
    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }
    
    /**
     * Get the payments for the supplier.
     */
    public function payments()
    {
        return $this->morphMany(Payment::class, 'paymentable');
    }
    
    /**
     * Get the purchases for the supplier.
     */
    public function purchases()
    {
        return $this->hasMany(Purchase::class);
    }
    
    /**
     * Get the purchase returns for the supplier.
     */
    public function purchaseReturns()
    {
        return $this->hasMany(PurchaseReturn::class);
    }
}
