<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Multitenancy\Models\Concerns\UsesTenantConnection;

class SaleReturnItem extends Model
{
    use HasFactory, UsesTenantConnection;
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'tenant_id',
        'sale_return_id',
        'product_id',
        'sale_item_id',
        'quantity',
        'price_at_sale',
        'subtotal',
    ];
    
    /**
     * Get the sale return that owns the item.
     */
    public function saleReturn()
    {
        return $this->belongsTo(SaleReturn::class);
    }
    
    /**
     * Get the product associated with the item.
     */
    public function product()
    {
        return $this->belongsTo(Product::class);
    }
    
    /**
     * Get the original sale item associated with this return item.
     */
    public function saleItem()
    {
        return $this->belongsTo(SaleItem::class);
    }
    
    /**
     * Get the tenant that owns the sale return item.
     */
    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }
}
