<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Multitenancy\Models\Concerns\UsesTenantConnection;

class InventoryLayer extends BaseModel
{
    use HasFactory, UsesTenantConnection;
    
    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'tenant_id',
        'product_id',
        'purchase_id',
        'purchase_item_id',
        'quantity_initial',
        'quantity_remaining',
        'unit_cost',
        'created_at',
    ];
    
    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'quantity_initial' => 'decimal:2',
        'quantity_remaining' => 'decimal:2',
        'unit_cost' => 'decimal:2',
        'created_at' => 'datetime',
    ];
    
    /**
     * Get the product that owns the inventory layer.
     */
    public function product()
    {
        return $this->belongsTo(Product::class);
    }
    
    /**
     * Get the purchase that created this inventory layer.
     */
    public function purchase()
    {
        return $this->belongsTo(Purchase::class);
    }
    
    /**
     * Get the purchase item that created this inventory layer.
     */
    public function purchaseItem()
    {
        return $this->belongsTo(PurchaseItem::class);
    }
}
