<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return $this->user()->can('manage-products');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'sku' => [
                'nullable',
                'string',
                'max:100',
                function ($attribute, $value, $fail) {
                    // Check if SKU is unique within the tenant
                    if ($value) {
                        $exists = \App\Models\Product::where('sku', $value)
                            ->where('tenant_id', $this->user()->tenant_id)
                            ->exists();
                        
                        if ($exists) {
                            $fail('The SKU has already been taken within your organization.');
                        }
                    }
                },
            ],
            'price' => 'required|numeric|min:0',
            'purchase_price' => 'nullable|numeric|min:0',
            'quantity' => 'nullable|integer|min:0',
            'reorder_point' => 'nullable|integer|min:0',
            'barcode' => 'nullable|string|max:100',
        ];
    }
}
