<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Inertia\Inertia;
use App\Traits\PermissionCheckTrait;

class ReportController extends Controller
{
    use PermissionCheckTrait;
    
    /**
     * Create a new controller instance.
     */
    public function __construct()
    {
        // Only require authentication, permission checks will be handled in each method
        $this->middleware('auth');
    }
    
    /**
     * Display the reports index/menu page.
     */
    public function index()
    {
        // Check for view reports permission
        $this->authorizeAnyPermission([
            'view-reports'
        ]);
        
        // Get user permissions for debugging
        $user = Auth::user();
        $userPermissions = $user->getAllPermissions()->pluck('name')->toArray();
        
        return Inertia::render('Reports/Index', [
            'debug' => [
                'permissions' => $userPermissions,
                'user_id' => $user->id,
                'user_role' => $user->role,
            ]
        ]);
    }
    
    /**
     * Display the sales report page.
     */
    public function salesReport()
    {
        // Check for view reports permission
        $this->authorizeAnyPermission([
            'view-reports'
        ]);
        
        return Inertia::render('Reports/SalesReport');
    }
    
    /**
     * Display the inventory report page.
     */
    public function inventoryReport()
    {
        // Check for view reports permission
        $this->authorizeAnyPermission([
            'view-reports'
        ]);
        
        return Inertia::render('Reports/InventoryReport');
    }
    
    /**
     * Display the expense report page.
     */
    public function expenseReport()
    {
        // Check for view reports permission
        $this->authorizeAnyPermission([
            'view-reports'
        ]);
        
        return Inertia::render('Reports/ExpenseReport');
    }
    
    /**
     * Display the purchase report page.
     */
    public function purchaseReport()
    {
        // Check for view reports permission
        $this->authorizeAnyPermission([
            'view-reports'
        ]);
        
        return Inertia::render('Reports/PurchaseReport');
    }
    
    /**
     * Display the sales returns report page.
     */
    public function salesReturnsReport()
    {
        return Inertia::render('Reports/SalesReturnReport');
    }
    
    /**
     * Display the purchase returns report page.
     */
    public function purchaseReturnsReport()
    {
        return Inertia::render('Reports/PurchaseReturnReport');
    }
}
