<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use App\Models\Payment;
use Illuminate\Http\Request;
use Inertia\Inertia;

class ChecksManagementController extends Controller
{
    /**
     * Display the main checks management dashboard.
     */
    public function index(Request $request)
    {
        // Get sales checks statistics
        $salesChecks = Payment::where('method', 'check')
                             ->where('paymentable_type', 'App\\Models\\Client')
                             ->get();
        
        $salesStats = [
            'total_count' => $salesChecks->count(),
            'total_amount' => $salesChecks->sum('amount'),
            'pending_count' => $salesChecks->where('check_status', 'pending')->count(),
            'paid_count' => $salesChecks->where('check_status', 'paid')->count(),
            'unpaid_count' => $salesChecks->where('check_status', 'unpaid')->count(),
            'overdue_count' => $salesChecks->filter(function ($check) {
                return $check->check_due_date < now()->toDateString() && $check->check_status === 'pending';
            })->count(),
            'pending_amount' => $salesChecks->where('check_status', 'pending')->sum('amount'),
            'paid_amount' => $salesChecks->where('check_status', 'paid')->sum('amount'),
            'unpaid_amount' => $salesChecks->where('check_status', 'unpaid')->sum('amount'),
            'overdue_amount' => $salesChecks->filter(function ($check) {
                return $check->check_due_date < now()->toDateString() && $check->check_status === 'pending';
            })->sum('amount'),
        ];
        
        // Get supplier checks statistics
        $supplierChecks = Payment::where('method', 'check')
                                ->where('paymentable_type', 'App\\Models\\Supplier')
                                ->get();
        
        $supplierStats = [
            'total_count' => $supplierChecks->count(),
            'total_amount' => $supplierChecks->sum('amount'),
            'pending_count' => $supplierChecks->where('check_status', 'pending')->count(),
            'paid_count' => $supplierChecks->where('check_status', 'paid')->count(),
            'unpaid_count' => $supplierChecks->where('check_status', 'unpaid')->count(),
            'overdue_count' => $supplierChecks->filter(function ($check) {
                return $check->check_due_date < now()->toDateString() && $check->check_status === 'pending';
            })->count(),
            'pending_amount' => $supplierChecks->where('check_status', 'pending')->sum('amount'),
            'paid_amount' => $supplierChecks->where('check_status', 'paid')->sum('amount'),
            'unpaid_amount' => $supplierChecks->where('check_status', 'unpaid')->sum('amount'),
            'overdue_amount' => $supplierChecks->filter(function ($check) {
                return $check->check_due_date < now()->toDateString() && $check->check_status === 'pending';
            })->sum('amount'),
        ];
        
        // Get recent checks activity (last 10 checks)
        $recentChecks = Payment::where('method', 'check')
                              ->with(['paymentable'])
                              ->orderBy('created_at', 'desc')
                              ->limit(10)
                              ->get()
                              ->map(function ($check) {
                                  return [
                                      'id' => $check->id,
                                      'amount' => $check->amount,
                                      'check_number' => $check->check_number,
                                      'check_due_date' => $check->check_due_date,
                                      'check_status' => $check->check_status,
                                      'paymentable_type' => $check->paymentable_type,
                                      'paymentable' => $check->paymentable ? [
                                          'id' => $check->paymentable->id,
                                          'name' => $check->paymentable->name,
                                      ] : null,
                                  ];
                              });
        
        return Inertia::render('ChecksManagement/Index', [
            'salesStats' => $salesStats,
            'supplierStats' => $supplierStats,
            'recentChecks' => $recentChecks,
        ]);
    }
}