<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Purchase;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PurchaseSearchController extends Controller
{
    /**
     * Search for purchases based on a query string
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function search(Request $request)
    {
        $query = $request->input('query');
        $status = $request->input('status', 'completed'); // Default to completed purchases
        
        $purchases = Purchase::with(['supplier', 'items.product'])
            ->where('tenant_id', Auth::user()->tenant_id)
            ->where('status', $status)
            ->where(function($q) use ($query) {
                // Search by ID
                if (is_numeric($query)) {
                    $q->where('id', $query);
                }
                
                // Search by supplier name
                $q->orWhereHas('supplier', function($supplierQuery) use ($query) {
                    $supplierQuery->where('name', 'like', "%{$query}%");
                });
                
                // Search by date (if query looks like a date)
                if (strtotime($query)) {
                    $date = date('Y-m-d', strtotime($query));
                    $q->orWhereDate('created_at', $date);
                }
            })
            ->orderBy('created_at', 'desc')
            ->limit(10) // Limit to 10 results for performance
            ->get();
        
        return response()->json([
            'purchases' => $purchases
        ]);
    }
}
